#include <koan.fx>

sampler left : register(s0) = sampler_state
{
  minfilter = linear;
  magfilter = linear;
};

sampler right : register(s1) = sampler_state
{
  minfilter = linear;
  magfilter = linear;
};

float2 g_base = float2(0, 0);
float2 g_scale = float2(1, 1);

float4 Stereo(
  float2 uv : texcoord0,
  float4 c : color0
) : color0
{
  if (g_renderView == 2)	// right
  {
    uv.x = uv.x * g_scale.y + g_base.y;
    c = tex2D( right, uv ) * c;
  }
  else				// mono, left
  {
    uv.x = uv.x * g_scale.x + g_base.x;
    c = tex2D( left, uv ) * c;
  }
  return c;
}

technique StereoImage
{
  pass P1
  {
    PixelShader = compile ps_2_0 Stereo();
  }
}
